#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <assert.h>
#include <math.h>
#include "cvect.h"
#include "triangle.h"

#define HPUA 4                  //hairs per unit area
#define HWIDTH .125             //hair width
#define HWVAR .25               //hair width percent variance
#define HLENGTH 1               //hair length
#define HLVAR .25               //hair length percent variance
#define HANGLE -45              //hair angle
#define HAVAR .25               //hair angle percent variance


void makefur(FILE * fpo, triangle& t, const int density);

int main(int argc, char **argv) {
    assert(argc == 3);
    FILE * fpi, * fpo;
    cvect c1, c2, c3;
    triangle t;
    char buf[256];
    fpi = fopen(argv[1],"r");
    fpo = fopen(argv[2],"w");
    assert(fpi != NULL);
    assert(fpo != NULL);

    fgets(buf,256,fpi);
    if (!feof(fpi)) do {
      if (strstr(buf,"triangle") != NULL) {
	fgets(buf,256,fpi);assert(feof(fpi) == false);
	assert(sscanf(buf," < %lf, %lf, %lf>", &(c1[0]), &(c1[1]), &(c1[2])) == 3);
	fgets(buf,256,fpi);assert(feof(fpi) == false);
	assert(sscanf(buf," < %lf, %lf, %lf>", &(c2[0]), &(c2[1]), &(c2[2])) == 3);
	fgets(buf,256,fpi);assert(feof(fpi) == false);
	assert(sscanf(buf," < %lf, %lf, %lf>", &(c3[0]), &(c3[1]), &(c3[2])) == 3);
	t.locate(c1,c2,c3);
	makefur(fpo,t,(int) sqrt(HPUA));
      }
      fgets(buf,256,fpi);
    } while (!feof(fpi));
    fclose(fpi);
    fclose(fpo);
	return 0;
}

cvect temp(int c2, triangle& t, const int density) {
  cvect ret;
  ret = t.corner[1] - t.corner[2];
  ret = ((double) c2) * ret;
  ret = ret / ((double) density);
  return ret;
}

cvect phirotate(cvect& v, double dphi) {
  double rho, theta, phi;
  cvect ret;
  rho = v.length();
  theta = atan2(v[0],-v[2]);
  phi = atan2(sqrt(v[2]*v[2] + v[0]*v[0]),v[1]) + dphi * M_PI / 180;
  ret[0] = rho * sin(theta) * sin(phi);
  ret[1] = rho * cos(phi);
  ret[2] = -rho * cos(theta) * sin(phi);
  return ret;
}

void makefur(FILE * fpo, triangle& t, const int density) {
  assert(fpo != NULL);
  assert(density != 0);
  int c1, c2;
  cvect b2, e2, hroot, htip, hside;
  double scaler;
  triangle hair;
  for (c1 = 0; c1 <= density; c1++) {
    b2 = t.corner[2] - t.corner[0];
    b2 = (double) c1 * b2;
    b2 = b2 / ((double) density);
//    b2 = c1 * (t.corner[2] - t.corner[0]) / ((double) density);
    e2 = t.corner[1] - t.corner[0];
    e2 = (double) c1 * e2;
    e2 = e2 / ((double) density);
//    e2 = c1 * (t.corner[1] - t.corner[0]) / ((double) density);
    for (
      c2 = 0;
      temp(c2,t,density).length() <= (e2 - b2).length(); //      (c2 * (t.corner[1] - t.corner[2]) / density).length() < (e2 - b2).length();
      c2++
    ) {
      hroot = t.corner[1] - t.corner[2];
      hroot = ((double) c2) * hroot;
      hroot = hroot / ((double) density);
      hroot = b2 + hroot;
      hroot = t.corner[0] + hroot;
//      hroot = b2 + c2 * (t.corner[1] - t.corner[2]) / density;

      htip = t.normal().unit();
      scaler = (rand() % 1000 - 500) * HLVAR / 1000 + 1;
      scaler *= HLENGTH;
      htip = scaler * htip;
      scaler = (rand() % 1000 - 500) * HAVAR / 1000 + 1;
      htip = phirotate(htip, HANGLE * scaler);

      hside = (t.corner[1] - t.corner[2]).unit();
      scaler = (rand() % 1000 - 500) * HWVAR / 1000 + 1;
      scaler *= HWIDTH;
      hside = scaler * hside;
      hair.locate(hroot - hside, hroot + hside, hroot - htip);
      fprintf(
	fpo,
	"triangle {<%f,%f,%f>,<%f,%f,%f>,<%f,%f,%f>}\n",
	hair.corner[0][0], hair.corner[0][1], hair.corner[0][2],
	hair.corner[1][0], hair.corner[1][1], hair.corner[1][2],
	hair.corner[2][0], hair.corner[2][1], hair.corner[2][2]
      );
    }
  }
}
